
import java.rmi.RemoteException;
import javax.naming.NamingException;
import javax.ejb.CreateException;
import Alkindi.Data.*;
import Alkindi.Services.*;
import Alkindi.Services.BeanIface.*;
import java.io.*;

public class AMTest
{
	IAccountManagerBean amb = null;
	
	public AMTest() 
	{
		try {
			amb = BeanUtil.getAcctMgr();	
		}
		catch(Exception e) {
			System.out.println("Exception in AMTest constructor:\n" + e.toString());
			System.exit(1);
		}
	}
	
	protected void finalize()
	{
		System.out.println("In finalizer");
		try {
			if (amb != null) {
				amb.remove();
				amb = null;
			}
		}
		catch (Exception e) {
			System.out.println(e.toString());			
			e.printStackTrace();
		}
			
		
	}

	protected void getScreenName(long uid) {
		try {
			SystemUser su = new SystemUser(uid);
			String sname = amb.getScreenName(su);
			System.out.println("Screen Name: " + sname);
		}
		catch (Exception e) {
			System.out.println(e.toString());
			e.printStackTrace();
		}
		return;
	}

	protected void getAcctInfo(SystemUser su) 
	{
		System.out.println("Made new System User");
		AccountInfo ai = null;
		try {
			ai = amb.getAccountInfo(su);
		}
		catch (Exception e) {
			System.out.println(e.toString());
			return;
		}
		System.out.println("Got the following AccountInfo:");
		if (ai == null) {
			System.out.println("AccountInfo is null.");
			return;
		}
		//	Print out AccountInfo fields
		//
		java.lang.reflect.Field flds[] = ai.getClass().getFields();
		for (int idx=0; idx<flds.length; idx++) {
			try { 
				System.out.print("\n" + flds[idx].getName() + " = ");
				System.out.print(flds[idx].get(ai).toString() );
			}
			// Ignore nulls fields for now...
			//
			catch (NullPointerException npe) {
			}
			catch (IllegalAccessException iae) {
			}
		}
	}
	
	public void getAcctInfo(long uid)
	{
		SystemUser su = new SystemUser(uid);
		getAcctInfo(su);
	}

	public void validateUser(String login, String pwd) 
	{
		System.out.println("Attempting to validate user....");
		try {
			SystemUser su = amb.validateUser(login, pwd);
			System.out.println("Done.");
			getAcctInfo(su);
		}
		catch(Exception e) {
			System.out.println("AlkExcept: " + e.toString());
		}
			
	}

	public static void usage() {
		String usage = "Usage:\n";
		usage += "\tCall thusly:\n";
		usage += "\tinfo [uid]\n";
		usage += "\tvalid [login] [pwd]\n";
		usage += "\tsname [uid]\n";
		System.out.println(usage);
		System.exit(1);
	}
		
	static void main(String[] args) 
	{
		if (args.length < 2) {
			usage();
		}
		
		AMTest This = new AMTest();

		if (args[0].compareTo("info") == 0) {
			try {
				long uid = Long.parseLong(args[1]);
				This.getAcctInfo(uid);
			}
			catch(NumberFormatException nfe) {
				System.out.println("Bad number format.");
				usage();
			}
		}
		else if (args[0].compareTo("valid") == 0) {
			if (args.length < 3) {
					usage();
			}
			This.validateUser(args[1], args[2]);				
		}
		else if (args[0].compareTo("sname") == 0) {
			try {
				long uid = Long.parseLong(args[1]);
				This.getScreenName(uid);
			}
			catch(NumberFormatException nfe) {
				System.out.println("Bad number format.");
				usage();
			}
		}			
		else {
			usage();
		}
		
			
	}
	
}
	
